%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%    METADATA:
%	   file: ppgem.cls 
%    date: 2015, April
%    author: PEIXOTO DE OLIVEIRA, Gustavo 
%            MATOS, Leon
%            ANJOS, Gustavo
% 
%	 e-mail: gustavo.anjos@uerj.br 
%
%    LICENSE:
%    This program is free software: you can redistribute it and/or
%    modify it under the terms of the GNU General Public License as
%    published by the Free Software Foundation, either version 3 of the
%    License, or (at your option) any later version. This program is
%    distributed in the hope that it will be useful, but WITHOUT ANY
%    WARRANTY; without even the implied warranty of MERCHANTABILITY or
%    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
%    License for more details. You should have received a copy of the
%    GNU General Public License along with this program.  If not, see
%    <http://www.gnu.org/licenses/>.
%    
%    DESCRIPTION
%    This class file was intened to comply with formatting and
%    publication specs for scientific sessions (e.g. seminars, round
%    tables and internal meetings) managed by the Laboratory of
%    Environmental Studies in Water Reservoirs as part of the Graduate
%    Program in Mech. Eng. at State University of Rio de Janeiro
%    (PPG-EM/UERJ). (http://www.gesar.uerj.br) This file is currently
%    maintained by Prof. Gustavo Anjos and Leon Matos.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\NeedsTeXFormat{LaTeX2e} 													 	

\ProvidesClass{ppgem}[2016/01/01 PPG-EM UERJ paper class]  

% Prevented options
\DeclareOption{10pt}{\OptionNotUsed} 
\DeclareOption{12pt}{\OptionNotUsed}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}} %  accept entries; * lets handle non-implemented options

% Standard options to compile
\ExecuteOptions{11pt,a4paper} 

% define option to use or not links
\def\uselinks{1}
\DeclareOption{links}{ \def\uselinks{1} }
\DeclareOption{nolinks}{ \def\uselinks{0} }

% define option to input or not date
\def\usedate{1}
\DeclareOption{date}{ \def\usedate{1} }
\DeclareOption{nodate}{ \def\usedate{0} }

%\newcommand{\isempty}[1]{%
%  \@ifmtarg{#1}{\def\flag{1}}{\def\flag{0}}}

% process options
\ProcessOptions\relax
\LoadClass[a4paper]{article}			    % loads based on article class

% required packages and settings
\RequirePackage[T1]{fontenc}   			    % allows accented characters
\RequirePackage{lmodern}
\RequirePackage[utf8]{inputenc} 
\RequirePackage{calc}						% allows arithmetic among Latex expressions
\RequirePackage{lipsum}						% inserts Latin text sample
\RequirePackage{graphicx}					% includes figures
\RequirePackage[main=english,brazil]{babel} % English as main language; Portuguese as the second
\RequirePackage{epsf,epsfig} 				% insert '.eps', ' .ps' postscript figures
\RequirePackage{setspace} 					% specify line spacing for sections and paragraphs through built-in commands 
\RequirePackage[skip=2pt,hang]{caption} 	% include caption
\RequirePackage{subfig} 					% use subfigure environment
\RequirePackage{nonfloat} 					% centralises tables and figs under nonfloat option [h] "here" 
\RequirePackage{amsfonts,amsmath,amssymb,bm}% use a plethora of mathematical AMS fonts
\RequirePackage{semtrans} 					% supports semitic languages
\RequirePackage{cjhebrew} 					% allows hebrew characters
\RequirePackage{upgreek}  					% upright style for Greek fonts 
\RequirePackage{blkarray} 					% labeled rows/columns in matrices
\RequirePackage[left]{lineno} 				% line numbering
\RequirePackage[svgnames]{xcolor} 			% 'svgnames'; color list: http://www.latextemplates.com/svgnames-colors
\RequirePackage{titlesec}	 				% provides additional features for titles
\RequirePackage[margin=2cm]{geometry}		% page layout
\RequirePackage[numbers]{natbib}			% bibliography
\RequirePackage{nomencl}					% nomenclature
\RequirePackage{ifthen}						% conditional
\RequirePackage[noblocks]{authblk} 			% author, affiliation 
\RequirePackage{multicol} 					% use of multiple columns
\RequirePackage{fancyhdr}					% page layout headers
\RequirePackage{tikz}						% duiagrams
\usetikzlibrary{shapes,shadows,arrows}		% shapes
\RequirePackage{indentfirst}  				% indents paragraph first line
% LOAD 'microtype' PACKAGE LAST!
\RequirePackage{microtype} 	                % text kerning (ajuste de espaço de caracter)

% paragraph
\setlength{\parindent}{0pt} % changes indent length
\setlength{\parskip}{2mm} 

% newcommands
\newcommand{\AuthorName}[1]{\def\@AuthorName{#1}}
\newcommand{\Coauthor}[1]{\def\@Coauthor{#1}}
%\newcommand{\Coauthor2}[1]{\def\@CoCoauthor1{#2}}
\newcommand{\Title}[1]{\def\@Title{#1}}
\newcommand{\CorrEmail}[1]{\def\@CorrEmail{#1}}
\newcommand{\InstA}[1]{\def\@InstA{#1}}
\newcommand{\InstB}[1]{\def\@InstB{#1}}
\newcommand{\Year}[1]{\def\@Year{#1}}
\newcommand{\DateOfPresentation}[1]{\def\@DateOfPresentation{#1}}
\newcommand{\PageNumber}[1]{\def\@PageNumber{#1}}

% use color links
\ifnum \uselinks = 1
\RequirePackage{color}
\definecolor{lkcolor}{rgb}{0.0,0.5,0.0}
\definecolor{ocre}{RGB}{20,120,140} % Define the orange color used for highlighting throughout the book
\RequirePackage[colorlinks,linkcolor=lkcolor,%
                urlcolor=ocre,citecolor=blue]{hyperref}
\fi

%% logo strip
\newcommand{\header}{
\begin{minipage}{\linewidth}
\begin{minipage}{\linewidth}
	\begin{minipage}{0.45\linewidth}
		\flushleft
		\includegraphics[height=25mm]{logos/sciences2024.jpg}
	\end{minipage}
\null\hfill
	\begin{minipage}{0.45\linewidth}
		\flushright
		\includegraphics[height=20mm]{logos/ens-rennes.png}
	\end{minipage}
\end{minipage}
%% title
\begin{center}
\vspace{1em}
\Large{ \color{ocre} \textsf{ \textbf{\MakeUppercase{ \@Title } } } }
\end{center}


%% AUTHOR / ADVISON AREA

\begin{minipage}{0.7\linewidth}
\ifthenelse{ \equal{\@InstB}{} }{	 % checks if institutionB is empty
\begin{tabular}{rl}
\textbf{Author:} & \@AuthorName$^{1}$ \qquad  \href{mailto:\@CorrEmail}{ \textit{ \@CorrEmail} } \\
%%% 
\textbf{Co-auteur:} & \@Coauthor1$^{1}$ \\
 & \quad { \scriptsize $^{1}$ \@InstA } \\
\end{tabular}
}
{
\begin{tabular}{rl}
\textbf{Author:} & \@AuthorName$^{1}$ \qquad  \href{mailto:\@CorrEmail}{ \textit{ \@CorrEmail} } \\
\textbf{Co-auteur:} & \@Coauthor$^{1}$ \text{; \! } \@CoCoauthor$^{2}$ \\
 & \quad { \scriptsize $^{1}$ \@InstA } \\
 & \quad { \scriptsize $^{2}$ \@InstB }
\end{tabular}
}
\end{minipage}
\end{minipage}
}

%% date and season
\newcommand{\dateandseason}{
\vspace*{-6mm}
\begin{minipage}{\linewidth}
    \begin{minipage}{0.495\textwidth}
        \vspace*{6mm}
        {\color{ocre}\small \@DateOfPresentation}
    \end{minipage}
    \begin{minipage}{0.495\textwidth}
        \flushright
        { \color{ocre} \textsf{Conférence Sciences$^{2024}$: saison \textbf{\@Year}}
            \\ \url{https://sciences2024.polytechnique.fr} }
    \end{minipage}

    \hrulefill
	\vspace{1cm}
\end{minipage}
}

%% builds header
\newcommand{\makeheader}{
\twocolumn[
  \begin{@twocolumnfalse}
\header
\dateandseason
  \end{@twocolumnfalse}
]

}

%%% defines keywords
%\newenvironment{keywords}{
%\noindent \textbf{Keywords:}
%}
%% defines keywords
\newenvironment{keywords}{
\noindent \textbf{Mots clefs:}
}

%%%--------------- 
%% section formatting
% \@startsection{<name>}{<level>}{<indent>}{<beforeskip>}{<afterskip>}{<style>}*[<altheading>]{<heading>} ; 
% part after the *, including the * is optional.
\renewcommand{\section}{\@startsection{section}{1}{0mm}{1pt}{1pt}{\addvspace{1pt}\sffamily\bfseries\large}}
\renewcommand{\subsection}{\@startsection{subsection}{2}{0mm}{1pt}{1pt}{\addvspace{1pt}\sffamily\bfseries\normalsize}}
\renewcommand{\subsubsection}{\@startsection{subsubsection}{3}{0mm}{1pt}{1pt}{\sffamily\normalsize}}

%% simple definitions: no page numbering / left and right headers
\pagenumbering{gobble}
\pagestyle{fancy}
% Section text font settings
\fancyhf{} \fancyhead[LE,RO]{\sffamily\normalsize\thepage} % Font setting for the page number in the header
\fancyhead[LO]{\leftmark} % Print the nearest section name on the left side of odd pages
\fancyhead[RE]{\leftmark} % Print the current chapter name on the right side of even pages
\renewcommand{\headrulewidth}{0.0pt} % Width of the rule under the header
\addtolength{\headheight}{2.5pt} % Increase the spacing around the header slightly
\renewcommand{\footrulewidth}{0pt} % Removes the rule in the footer
\lhead{}%{\sffamily\bfseries\normalsize{PPG-EM Seminars}}
\rhead{}%{\sffamily\bfseries\normalsize{}}


%% redefining names
\renewcommand{\refname}{\normalsize{References}}
\renewcommand{\nomname}{List of Symbols}

%% nomenclature
\renewcommand{\nomgroup}[1]{%
\ifthenelse{\equal{#1}{R}}{\item[\textbf{Roman letters}]}{%
\ifthenelse{\equal{#1}{G}}{\item[Greek letters]}{}}}

%% commands
\newcommand{\lsp}{\linespread{1.3}} % equivalent to Word 1.5 spacing
%\newcommand{\lspd}{\linespread{1.6}} % equivalent to Word double spacing